Attribute VB_Name = "mdRepositionAxes"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function RepositionAxes(xTranslation As Double, yTranslation As Double, angle As Double)

'Convenience Function to position axes to given coordinates with required orientation

'rotate and translate the axes
TranslateAxes xTranslation, yTranslation
RotateAxes angle

End Function


Function TranslateAxes(xTranslation As Double, yTranslation As Double)

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the active Partdocument,Workplane
Dim Part As PartDocument
Set Part = app.GetActiveDoc
Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

'Create an origin vector
Dim vector1 As zVector
Set vector1 = app.GetClass("Vector").CreateVector(xTranslation, yTranslation, 0)

'Get the transformation matrix for translating the origin
Dim transMatrix As zMatrix
      
Dim vector2 As zVector
Dim vector3 As zVector
Dim vector4 As zVector
  
Set vector2 = wp.GetLocalOrigin()
Set vector3 = vector1.subtract(vector2)
Set transMatrix = app.GetClass("Matrix").CreateTranslationMatrix(vector3)
  
'Set the new origin
Set localorigin = wp.GetLocalOrigin
Set vector4 = transMatrix.MultiplyByVector(localorigin)
wp.SetLocalOrigin vector4
   
Dim dir1 As zDirection
Dim dir2 As zDirection
Dim dir3 As zDirection
Dim dir4 As zDirection
   
Set dir1 = wp.GetLocalX
Set dir2 = wp.GetLocalY
   
Set dir3 = transMatrix.MultiplyByDirection(dir1)
Set dir4 = transMatrix.MultiplyByDirection(dir2)
   
wp.SetLocalAxes dir3, dir4
              
End Function

Function RotateAxes(angle As Double)

'Conveninece Function to rotate the axes through a specified angle in degrees

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the active Partdocument,Workplane
Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim workplane As aWorkplane
Set workplane = Part.GetActiveWorkplane

'Get the existing origin
Dim origin As zVector
Dim localX  As zDirection
Dim localY As zDirection
Set origin = workplane.GetLocalOrigin()
Set localX = workplane.GetLocalX()
Set localY = workplane.GetLocalY()

'Convert the angle from degrees to radians
Dim radianAngle
radianAngle = (3.142857142857 * angle) / 180

Dim cosine As Double
Dim sine As Double
cosine = Cos(radianAngle)
sine = Sin(radianAngle)

Dim newX As zVector
Dim newY As zVector

Set newX = localX.Multiply(cosine).Add(localY.Multiply(sine))
Set newY = localX.Multiply(-sine).Add(localY.Multiply(cosine))

'Gets the transformation matrix
Dim oldMapping As zMatrix
Dim newMapping As zMatrix
Dim transMatrix As zMatrix

Set oldMapping = app.GetClass("Matrix").CreateTranslationMatrix(origin).MultiplyByMatrix(app.GetClass("Matrix").CreateRotationMatrix(localX, localY))
Set newMapping = app.GetClass("Matrix").CreateTranslationMatrix(origin).MultiplyByMatrix(app.GetClass("Matrix").CreateRotationMatrix(newX.GetDirection, newY.GetDirection))
Set transMatrix = newMapping.MultiplyByMatrix(oldMapping.GetInverse())

workplane.SetLocalOrigin transMatrix.MultiplyByVector(workplane.GetLocalOrigin)
workplane.SetLocalAxes transMatrix.MultiplyByDirection(workplane.GetLocalX), transMatrix.MultiplyByDirection(workplane.GetLocalY)

End Function
